/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.helper;

import net.caffeinemc.mods.sodium.client.render.helper.GeometryHelper;
import net.caffeinemc.mods.sodium.client.render.model.QuadViewImpl;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import org.joml.Vector3f;
import org.jspecify.annotations.NonNull;

public abstract class NormalHelper {
    private NormalHelper() {
    }

    public static void computeFaceNormal(@NonNull Vector3f saveTo, QuadViewImpl q) {
        float normZ;
        float dx0;
        float dx1;
        float normY;
        float dy1;
        float dz0;
        class_2350 nominalFace = q.getNominalFace();
        if (nominalFace != null && GeometryHelper.isQuadParallelToFace(nominalFace, q)) {
            class_2382 vec = nominalFace.method_62675();
            saveTo.set((float)vec.method_10263(), (float)vec.method_10264(), (float)vec.method_10260());
            return;
        }
        float x0 = q.getX(0);
        float y0 = q.getY(0);
        float z0 = q.getZ(0);
        float x1 = q.getX(1);
        float y1 = q.getY(1);
        float z1 = q.getZ(1);
        float x2 = q.getX(2);
        float y2 = q.getY(2);
        float z2 = q.getZ(2);
        float x3 = q.getX(3);
        float y3 = q.getY(3);
        float dy0 = y2 - y0;
        float z3 = q.getZ(3);
        float dz1 = z3 - z1;
        float normX = dy0 * dz1 - (dz0 = z2 - z0) * (dy1 = y3 - y1);
        float l = (float)Math.sqrt(normX * normX + (normY = dz0 * (dx1 = x3 - x1) - (dx0 = x2 - x0) * dz1) * normY + (normZ = dx0 * dy1 - dy0 * dx1) * normZ);
        if (l != 0.0f) {
            normX /= l;
            normY /= l;
            normZ /= l;
        }
        saveTo.set(normX, normY, normZ);
    }
}

